<?php
/**
 * The template for displaying single posts
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

get_header();
?>

<div class="content-area">
    
    <?php
    while ( have_posts() ) :
        the_post();
        ?>
        
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            
            <!-- Post Header -->
            <header class="entry-header">
                <h1 class="entry-title"><?php the_title(); ?></h1>
                
                <!-- Post Meta with Semantic Markup -->
                <div class="entry-meta">
                    <span class="posted-on">
                        <time class="entry-date published" datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>" itemprop="datePublished">
                            <?php echo esc_html( get_the_date() ); ?>
                        </time>
                        <?php if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) : ?>
                            <time class="updated" datetime="<?php echo esc_attr( get_the_modified_date( 'c' ) ); ?>" itemprop="dateModified">
                                <?php
                                /* translators: %s: Modified date */
                                printf( esc_html__( '(Updated: %s)', 'wcag-accessible-pro' ), esc_html( get_the_modified_date() ) );
                                ?>
                            </time>
                        <?php endif; ?>
                    </span>
                    <span class="byline">
                        <?php
                        /* translators: %s: Post author */
                        printf(
                            esc_html__( 'by %s', 'wcag-accessible-pro' ),
                            '<span class="author vcard" itemprop="author"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                        );
                        ?>
                    </span>
                </div><!-- .entry-meta -->
            </header><!-- .entry-header -->
            
            <!-- Featured Image with Figure and Figcaption -->
            <?php if ( has_post_thumbnail() ) : ?>
                <figure class="post-thumbnail">
                    <?php
                    the_post_thumbnail(
                        'large',
                        array(
                            'alt' => the_title_attribute(
                                array(
                                    'echo' => false,
                                )
                            ),
                        )
                    );
                    ?>
                    <?php
                    $caption = get_the_post_thumbnail_caption();
                    if ( $caption ) :
                        ?>
                        <figcaption><?php echo wp_kses_post( $caption ); ?></figcaption>
                    <?php endif; ?>
                </figure><!-- .post-thumbnail -->
            <?php endif; ?>
            
            <!-- Post Content -->
            <div class="entry-content" itemprop="articleBody">
                <?php
                the_content();
                
                wp_link_pages(
                    array(
                        'before' => '<nav class="page-links" aria-label="' . esc_attr__( 'Page navigation', 'wcag-accessible-pro' ) . '"><span class="page-links-title">' . esc_html__( 'Pages:', 'wcag-accessible-pro' ) . '</span>',
                        'after'  => '</nav>',
                    )
                );
                ?>
            </div><!-- .entry-content -->
            
            <!-- Post Footer -->
            <footer class="entry-footer">
                <?php
                // Categories
                $categories_list = get_the_category_list( esc_html__( ', ', 'wcag-accessible-pro' ) );
                if ( $categories_list ) {
                    /* translators: %s: List of categories */
                    printf( '<span class="cat-links">' . esc_html__( 'Categories: %s', 'wcag-accessible-pro' ) . '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                }
                
                // Tags
                $tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'wcag-accessible-pro' ) );
                if ( $tags_list ) {
                    /* translators: %s: List of tags */
                    printf( '<span class="tags-links">' . esc_html__( 'Tags: %s', 'wcag-accessible-pro' ) . '</span>', $tags_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                }
                ?>
            </footer><!-- .entry-footer -->
            
        </article><!-- #post-<?php the_ID(); ?> -->
        
        <!-- Post Navigation with ARIA Labels -->
        <nav class="post-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Post navigation', 'wcag-accessible-pro' ); ?>">
            <?php
            the_post_navigation(
                array(
                    'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'wcag-accessible-pro' ) . '</span> <span class="nav-title">%title</span>',
                    'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'wcag-accessible-pro' ) . '</span> <span class="nav-title">%title</span>',
                )
            );
            ?>
        </nav><!-- .post-navigation -->
        
        <!-- Comments Section -->
        <?php
        if ( comments_open() || get_comments_number() ) :
            comments_template();
        endif;
        ?>
        
        <?php
    endwhile;
    ?>
    
</div><!-- .content-area -->

<?php
get_footer();

