<?php
/**
 * Search Form Template
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */
?>

<form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="<?php esc_attr_e( 'Search this website', 'wcag-accessible-pro' ); ?>">
    <label for="search-field-<?php echo esc_attr( uniqid() ); ?>">
        <span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'wcag-accessible-pro' ); ?></span>
    </label>
    <input 
        type="search" 
        id="search-field-<?php echo esc_attr( uniqid() ); ?>" 
        class="search-field" 
        placeholder="<?php esc_attr_e( 'Search...', 'wcag-accessible-pro' ); ?>" 
        value="<?php echo get_search_query(); ?>" 
        name="s" 
        required
        aria-required="true"
    />
    <button type="submit" class="search-submit">
        <span class="screen-reader-text"><?php esc_html_e( 'Search', 'wcag-accessible-pro' ); ?></span>
        <span aria-hidden="true">&#128269;</span>
    </button>
</form>

