<?php
/**
 * The template for displaying pages
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

get_header();
?>

<div class="content-area">
    
    <?php
    while ( have_posts() ) :
        the_post();
        ?>
        
        <article id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
            
            <!-- Page Header -->
            <header class="entry-header">
                <h1 class="entry-title"><?php the_title(); ?></h1>
            </header><!-- .entry-header -->
            
            <!-- Featured Image with Figure and Figcaption -->
            <?php if ( has_post_thumbnail() ) : ?>
                <figure class="page-thumbnail">
                    <?php
                    the_post_thumbnail(
                        'large',
                        array(
                            'alt' => the_title_attribute(
                                array(
                                    'echo' => false,
                                )
                            ),
                        )
                    );
                    ?>
                    <?php
                    $caption = get_the_post_thumbnail_caption();
                    if ( $caption ) :
                        ?>
                        <figcaption><?php echo wp_kses_post( $caption ); ?></figcaption>
                    <?php endif; ?>
                </figure><!-- .page-thumbnail -->
            <?php endif; ?>
            
            <!-- Page Content -->
            <div class="entry-content">
                <?php
                the_content();
                
                wp_link_pages(
                    array(
                        'before' => '<nav class="page-links" aria-label="' . esc_attr__( 'Page navigation', 'wcag-accessible-pro' ) . '"><span class="page-links-title">' . esc_html__( 'Pages:', 'wcag-accessible-pro' ) . '</span>',
                        'after'  => '</nav>',
                    )
                );
                ?>
            </div><!-- .entry-content -->
            
        </article><!-- #page-<?php the_ID(); ?> -->
        
        <!-- Comments Section -->
        <?php
        if ( comments_open() || get_comments_number() ) :
            comments_template();
        endif;
        ?>
        
        <?php
    endwhile;
    ?>
    
</div><!-- .content-area -->

<?php
get_footer();

