<?php
/**
 * The main template file
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

get_header();
?>

<div class="content-area">
    
    <?php if ( have_posts() ) : ?>
        
        <!-- Archive Header with Proper Heading Hierarchy -->
        <?php if ( is_home() && ! is_front_page() ) : ?>
            <header class="page-header">
                <h1 class="page-title"><?php single_post_title(); ?></h1>
            </header>
        <?php elseif ( is_archive() ) : ?>
            <header class="page-header">
                <h1 class="page-title"><?php the_archive_title(); ?></h1>
                <?php the_archive_description( '<div class="archive-description">', '</div>' ); ?>
            </header>
        <?php elseif ( is_search() ) : ?>
            <header class="page-header">
                <h1 class="page-title">
                    <?php
                    /* translators: %s: Search query */
                    printf( esc_html__( 'Search Results for: %s', 'wcag-accessible-pro' ), '<span>' . get_search_query() . '</span>' );
                    ?>
                </h1>
            </header>
        <?php endif; ?>
        
        <!-- Posts Loop with Semantic Article Tags -->
        <div class="posts-list" role="list">
            <?php
            while ( have_posts() ) :
                the_post();
                ?>
                
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> role="listitem">
                    
                    <!-- Post Header -->
                    <header class="entry-header">
                        <?php
                        if ( is_singular() ) :
                            the_title( '<h1 class="entry-title">', '</h1>' );
                        else :
                            the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
                        endif;
                        ?>
                        
                        <!-- Post Meta with Semantic Time Element -->
                        <div class="entry-meta">
                            <span class="posted-on">
                                <time class="entry-date published" datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
                                    <?php echo esc_html( get_the_date() ); ?>
                                </time>
                            </span>
                            <span class="byline">
                                <?php
                                /* translators: %s: Post author */
                                printf(
                                    esc_html__( 'by %s', 'wcag-accessible-pro' ),
                                    '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                                );
                                ?>
                            </span>
                        </div><!-- .entry-meta -->
                    </header><!-- .entry-header -->
                    
                    <!-- Featured Image with Proper Alt Text -->
                    <?php if ( has_post_thumbnail() ) : ?>
                        <div class="post-thumbnail">
                            <a href="<?php the_permalink(); ?>" aria-label="<?php the_title_attribute(); ?>">
                                <?php
                                the_post_thumbnail(
                                    'large',
                                    array(
                                        'alt' => the_title_attribute(
                                            array(
                                                'echo' => false,
                                            )
                                        ),
                                    )
                                );
                                ?>
                            </a>
                        </div><!-- .post-thumbnail -->
                    <?php endif; ?>
                    
                    <!-- Post Content -->
                    <div class="entry-content">
                        <?php
                        if ( is_singular() ) :
                            the_content();
                            
                            wp_link_pages(
                                array(
                                    'before' => '<nav class="page-links" aria-label="' . esc_attr__( 'Page navigation', 'wcag-accessible-pro' ) . '"><span class="page-links-title">' . esc_html__( 'Pages:', 'wcag-accessible-pro' ) . '</span>',
                                    'after'  => '</nav>',
                                )
                            );
                        else :
                            the_excerpt();
                        endif;
                        ?>
                    </div><!-- .entry-content -->
                    
                    <!-- Post Footer -->
                    <footer class="entry-footer">
                        <?php
                        // Categories
                        $categories_list = get_the_category_list( esc_html__( ', ', 'wcag-accessible-pro' ) );
                        if ( $categories_list ) {
                            /* translators: %s: List of categories */
                            printf( '<span class="cat-links">' . esc_html__( 'Categories: %s', 'wcag-accessible-pro' ) . '</span>', $categories_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        }
                        
                        // Tags
                        $tags_list = get_the_tag_list( '', esc_html_x( ', ', 'list item separator', 'wcag-accessible-pro' ) );
                        if ( $tags_list ) {
                            /* translators: %s: List of tags */
                            printf( '<span class="tags-links">' . esc_html__( 'Tags: %s', 'wcag-accessible-pro' ) . '</span>', $tags_list ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        }
                        ?>
                    </footer><!-- .entry-footer -->
                    
                </article><!-- #post-<?php the_ID(); ?> -->
                
                <?php
            endwhile;
            ?>
        </div><!-- .posts-list -->
        
        <!-- Pagination with ARIA Labels -->
        <nav class="pagination" role="navigation" aria-label="<?php esc_attr_e( 'Posts pagination', 'wcag-accessible-pro' ); ?>">
            <?php
            the_posts_pagination(
                array(
                    'mid_size'  => 2,
                    'prev_text' => '<span aria-hidden="true">&laquo;</span> <span class="screen-reader-text">' . esc_html__( 'Previous page', 'wcag-accessible-pro' ) . '</span>',
                    'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next page', 'wcag-accessible-pro' ) . '</span> <span aria-hidden="true">&raquo;</span>',
                )
            );
            ?>
        </nav><!-- .pagination -->
        
    <?php else : ?>
        
        <!-- No Posts Found -->
        <section class="no-results not-found">
            <header class="page-header">
                <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'wcag-accessible-pro' ); ?></h1>
            </header><!-- .page-header -->
            
            <div class="page-content">
                <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
                    <p>
                        <?php
                        /* translators: %s: Link to create a new post */
                        printf(
                            wp_kses(
                                __( 'Ready to publish your first post? <a href="%s">Get started here</a>.', 'wcag-accessible-pro' ),
                                array(
                                    'a' => array(
                                        'href' => array(),
                                    ),
                                )
                            ),
                            esc_url( admin_url( 'post-new.php' ) )
                        );
                        ?>
                    </p>
                <?php elseif ( is_search() ) : ?>
                    <p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with different keywords.', 'wcag-accessible-pro' ); ?></p>
                    <?php get_search_form(); ?>
                <?php else : ?>
                    <p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'wcag-accessible-pro' ); ?></p>
                    <?php get_search_form(); ?>
                <?php endif; ?>
            </div><!-- .page-content -->
        </section><!-- .no-results -->
        
    <?php endif; ?>
    
</div><!-- .content-area -->

<?php
get_footer();

