<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="page" class="site-container">

<?php if ( wcag_is_feature_enabled( 'enable_skip_links' ) ) : ?>
<!-- Skip Links for Accessibility (WCAG 2.1 SC 2.4.1) -->
<a class="skip-link screen-reader-text" href="#main"><?php esc_html_e( 'Skip to main content', 'wcag-accessible-pro' ); ?></a>
<a class="skip-link screen-reader-text" href="#primary-navigation"><?php esc_html_e( 'Skip to navigation', 'wcag-accessible-pro' ); ?></a>
<?php endif; ?>

<?php
/**
 * Native Semantic Header Integration
 *
 * If Elementor Header Template is active, render it inside native <header> tag
 * Otherwise, use default WordPress header
 */
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'header' ) ) {
    // Elementor header is rendered - already wrapped in semantic <header> tag by our filter
} else {
    // Default WordPress Header with Semantic HTML5
    ?>
    <header id="masthead" class="site-header" role="banner">
    <div class="header-inner">

        <!-- Site Branding -->
        <div class="site-branding">
            <?php
            if ( has_custom_logo() ) {
                the_custom_logo();
            } else {
                ?>
                <h1 class="site-title">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php bloginfo( 'name' ); ?>
                </a>
                </h1>
                <?php
                $description = get_bloginfo( 'description', 'display' );
                if ( $description || is_customize_preview() ) {
                    ?>
                    <p class="site-description"><?php echo esc_html( $description ); ?></p>
                    <?php
                }
            }
            ?>
        </div>

        <!-- Primary Navigation with ARIA Landmarks -->
        <nav id="primary-navigation" class="main-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Primary Navigation', 'wcag-accessible-pro' ); ?>">
            <?php
            wp_nav_menu(
                array(
                    'theme_location' => 'primary',
                    'menu_id'        => 'primary-menu',
                    'menu_class'     => 'primary-menu',
                    'container'      => false,
                    'fallback_cb'    => false,
                    'items_wrap'     => '<ul id="%1$s" class="%2$s" role="menubar">%3$s</ul>',
                )
            );
            ?>
        </nav>

    </div>
    </header>
    <?php
}
?>

<!-- Main Content Area with Semantic HTML5 -->
<main id="main" class="site-main" role="main" tabindex="-1">

