</main>

<?php
/**
 * Native Semantic Footer Integration
 *
 * If Elementor Footer Template is active, render it inside native <footer> tag
 * Otherwise, use default WordPress footer
 */
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'footer' ) ) {
    // Elementor footer is rendered - already wrapped in semantic <footer> tag by our filter
} else {
    // Default WordPress Footer with Semantic HTML5
    ?>
    <footer id="footer" class="site-footer" role="contentinfo">
    <div class="footer-inner">

        <!-- Footer Navigation -->
        <?php if ( has_nav_menu( 'footer' ) ) : ?>
        <nav class="footer-navigation" role="navigation" aria-label="<?php esc_attr_e( 'Footer Navigation', 'wcag-accessible-pro' ); ?>">
            <?php
            wp_nav_menu(
                array(
                    'theme_location' => 'footer',
                    'menu_id'        => 'footer-menu',
                    'menu_class'     => 'footer-menu',
                    'container'      => false,
                    'depth'          => 1,
                    'items_wrap'     => '<ul id="%1$s" class="%2$s" role="menubar">%3$s</ul>',
                )
            );
            ?>
        </nav>
        <?php endif; ?>

        <!-- Copyright and Site Info -->
        <div class="site-info">
        <p>
            <?php
            printf(
                esc_html__( '&copy; %s ', 'wcag-accessible-pro' ),
                esc_html( date_i18n( 'Y' ) )
            );
            ?>
            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
            <?php bloginfo( 'name' ); ?>
            </a>
            <span class="sep"> | </span>
            <?php
            printf(
                esc_html__( 'Theme: %s', 'wcag-accessible-pro' ),
                '<a href="https://contentplanning.ai" rel="nofollow">WCAG Accessible Pro</a>'
            );
            ?>
        </p>
        </div>

    </div>
    </footer>
    <?php
}
?>
    
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>

