<?php
/**
 * Comments Template
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

if ( post_password_required() ) {
    return;
}
?>

<section id="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>
        <h2 class="comments-title">
            <?php
            $comment_count = get_comments_number();
            if ( '1' === $comment_count ) {
                printf(
                    /* translators: %s: Post title */
                    esc_html__( 'One comment on &ldquo;%s&rdquo;', 'wcag-accessible-pro' ),
                    '<span>' . wp_kses_post( get_the_title() ) . '</span>'
                );
            } else {
                printf(
                    /* translators: 1: Number of comments, 2: Post title */
                    esc_html( _n( '%1$s comment on &ldquo;%2$s&rdquo;', '%1$s comments on &ldquo;%2$s&rdquo;', $comment_count, 'wcag-accessible-pro' ) ),
                    number_format_i18n( $comment_count ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    '<span>' . wp_kses_post( get_the_title() ) . '</span>'
                );
            }
            ?>
        </h2>

        <ol class="comment-list" role="list">
            <?php
            wp_list_comments(
                array(
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'avatar_size' => 60,
                    'callback'    => 'wcag_accessible_pro_comment_callback',
                )
            );
            ?>
        </ol>

        <?php
        the_comments_navigation(
            array(
                'prev_text' => '<span class="screen-reader-text">' . esc_html__( 'Previous comments', 'wcag-accessible-pro' ) . '</span> <span aria-hidden="true">&laquo;</span>',
                'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next comments', 'wcag-accessible-pro' ) . '</span> <span aria-hidden="true">&raquo;</span>',
            )
        );
        ?>

        <?php if ( ! comments_open() ) : ?>
            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'wcag-accessible-pro' ); ?></p>
        <?php endif; ?>

    <?php endif; ?>

    <?php
    comment_form(
        array(
            'title_reply_before' => '<h3 id="reply-title" class="comment-reply-title">',
            'title_reply_after'  => '</h3>',
            'comment_field'      => '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'Comment', 'wcag-accessible-pro' ) . ' <span class="required" aria-label="' . esc_attr__( 'Required', 'wcag-accessible-pro' ) . '">*</span></label><textarea id="comment" name="comment" cols="45" rows="8" maxlength="65525" required="required" aria-required="true"></textarea></p>',
            'fields'             => array(
                'author' => '<p class="comment-form-author"><label for="author">' . esc_html__( 'Name', 'wcag-accessible-pro' ) . ' <span class="required" aria-label="' . esc_attr__( 'Required', 'wcag-accessible-pro' ) . '">*</span></label><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" maxlength="245" required="required" aria-required="true" /></p>',
                'email'  => '<p class="comment-form-email"><label for="email">' . esc_html__( 'Email', 'wcag-accessible-pro' ) . ' <span class="required" aria-label="' . esc_attr__( 'Required', 'wcag-accessible-pro' ) . '">*</span></label><input id="email" name="email" type="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" maxlength="100" aria-describedby="email-notes" required="required" aria-required="true" /></p>',
                'url'    => '<p class="comment-form-url"><label for="url">' . esc_html__( 'Website', 'wcag-accessible-pro' ) . '</label><input id="url" name="url" type="url" value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" maxlength="200" /></p>',
            ),
        )
    );
    ?>

</section><!-- #comments -->

<?php
/**
 * Custom comment callback for accessibility
 */
function wcag_accessible_pro_comment_callback( $comment, $args, $depth ) {
    ?>
    <li id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?> role="listitem">
        <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">
            <footer class="comment-meta">
                <div class="comment-author vcard">
                    <?php
                    if ( 0 !== $args['avatar_size'] ) {
                        echo get_avatar( $comment, $args['avatar_size'], '', get_comment_author( $comment ), array( 'loading' => 'lazy' ) );
                    }
                    ?>
                    <b class="fn"><?php echo get_comment_author_link( $comment ); ?></b>
                    <span class="says screen-reader-text"><?php esc_html_e( 'says:', 'wcag-accessible-pro' ); ?></span>
                </div><!-- .comment-author -->

                <div class="comment-metadata">
                    <a href="<?php echo esc_url( get_comment_link( $comment, $args ) ); ?>">
                        <time datetime="<?php comment_time( 'c' ); ?>">
                            <?php
                            /* translators: 1: Comment date, 2: Comment time */
                            printf( esc_html__( '%1$s at %2$s', 'wcag-accessible-pro' ), get_comment_date( '', $comment ), get_comment_time() );
                            ?>
                        </time>
                    </a>
                    <?php edit_comment_link( esc_html__( 'Edit', 'wcag-accessible-pro' ), '<span class="edit-link">', '</span>' ); ?>
                </div><!-- .comment-metadata -->

                <?php if ( '0' === $comment->comment_approved ) : ?>
                    <p class="comment-awaiting-moderation" role="status"><?php esc_html_e( 'Your comment is awaiting moderation.', 'wcag-accessible-pro' ); ?></p>
                <?php endif; ?>
            </footer><!-- .comment-meta -->

            <div class="comment-content">
                <?php comment_text(); ?>
            </div><!-- .comment-content -->

            <?php
            comment_reply_link(
                array_merge(
                    $args,
                    array(
                        'add_below' => 'div-comment',
                        'depth'     => $depth,
                        'max_depth' => $args['max_depth'],
                        'before'    => '<div class="reply">',
                        'after'     => '</div>',
                    )
                )
            );
            ?>
        </article><!-- .comment-body -->
    <?php
}

