<?php
/**
 * The template for displaying archive pages
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

get_header();
?>

<div class="content-area">
    
    <?php if ( have_posts() ) : ?>
        
        <header class="page-header">
            <?php
            the_archive_title( '<h1 class="page-title">', '</h1>' );
            the_archive_description( '<div class="archive-description">', '</div>' );
            ?>
        </header><!-- .page-header -->
        
        <div class="posts-list" role="list">
            <?php
            while ( have_posts() ) :
                the_post();
                get_template_part( 'template-parts/content', get_post_type() );
            endwhile;
            ?>
        </div><!-- .posts-list -->
        
        <nav class="pagination" role="navigation" aria-label="<?php esc_attr_e( 'Posts pagination', 'wcag-accessible-pro' ); ?>">
            <?php
            the_posts_pagination(
                array(
                    'mid_size'  => 2,
                    'prev_text' => '<span aria-hidden="true">&laquo;</span> <span class="screen-reader-text">' . esc_html__( 'Previous page', 'wcag-accessible-pro' ) . '</span>',
                    'next_text' => '<span class="screen-reader-text">' . esc_html__( 'Next page', 'wcag-accessible-pro' ) . '</span> <span aria-hidden="true">&raquo;</span>',
                )
            );
            ?>
        </nav><!-- .pagination -->
        
    <?php else : ?>
        
        <section class="no-results not-found">
            <header class="page-header">
                <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'wcag-accessible-pro' ); ?></h1>
            </header><!-- .page-header -->
            
            <div class="page-content">
                <p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'wcag-accessible-pro' ); ?></p>
                <?php get_search_form(); ?>
            </div><!-- .page-content -->
        </section><!-- .no-results -->
        
    <?php endif; ?>
    
</div><!-- .content-area -->

<?php
get_footer();

