# WCAG Theme Settings - Dokumentation

## 📍 Wo finde ich die Einstellungen?

**WordPress Admin → Design → WCAG Settings**

oder direkt:

**WordPress Admin → Appearance → WCAG Settings**

---

## 🎛️ Verfügbare Einstellungen

Alle WCAG-Features können einzeln aktiviert oder deaktiviert werden. Dies ist besonders nützlich, wenn Sie bestimmte Features bereits manuell implementiert haben.

### 1. **Breadcrumb Navigation** ✅
- **WCAG**: 2.4.8 - Level AAA
- **Funktion**: Hierarchische Navigation (Home / Kategorie / Beitrag)
- **Schema.org**: Ja (BreadcrumbList Markup)
- **Deaktivieren wenn**: Sie bereits ein Breadcrumb-Plugin verwenden (z.B. Yoast SEO, Rank Math)

**Verwendung im Template**:
```php
<?php
if ( function_exists( 'wcag_accessible_pro_breadcrumbs' ) ) {
    wcag_accessible_pro_breadcrumbs();
}
?>
```

---

### 2. **Accessibility Toolbar** ✅
- **Funktion**: Floating Toolbar mit Accessibility-Optionen
- **Features**:
  - 🔤 A-/A+: Schriftgröße anpassen (80%-200%)
  - 🌙 Dark Mode: Dunkler Modus
  - ◐ High Contrast: Hoher Kontrast
  - ↺ Reset: Zurücksetzen
- **Position**: Fixed rechts, vertikal zentriert
- **Deaktivieren wenn**: Sie ein eigenes Accessibility-Widget verwenden

---

### 3. **Session Timeout Warning** ✅
- **WCAG**: 2.2.6 - Level AAA
- **Funktion**: Warnt Benutzer 5 Minuten vor Session-Ablauf
- **Features**:
  - ARIA Live Region Ankündigung
  - Visuelles Modal mit "Session verlängern"-Button
  - WordPress Heartbeat API Integration
- **Deaktivieren wenn**: Sie ein eigenes Session-Management haben

---

### 4. **Autocomplete Attributes** ✅
- **WCAG**: 1.3.6 - Level AAA
- **Funktion**: Automatisches Hinzufügen von `autocomplete`-Attributen
- **Unterstützte Felder**:
  - Email → `autocomplete="email"`
  - Name → `autocomplete="name"`
  - Telefon → `autocomplete="tel"`
  - Adresse → `autocomplete="street-address"`
  - PLZ → `autocomplete="postal-code"`
- **Kompatibilität**: WordPress-Formulare + Elementor Forms
- **Deaktivieren wenn**: Sie Autocomplete manuell setzen

---

### 5. **Video Accessibility Enhancements** ✅
- **WCAG**: 1.2.x (Time-based Media)
- **Features**:
  - Automatische `title`-Attribute für Video-iFrames
  - HTML5 Video Enhancement (controls, preload)
  - Admin-Hinweise für Caption-Anforderungen
  - WebVTT Caption Template Download
- **Deaktivieren wenn**: Sie Videos manuell mit Captions versehen

---

### 6. **Heading Hierarchy Validation** ✅
- **WCAG**: 2.4.10 - Level AAA
- **Funktion**: Prüft H1-H6 Hierarchie auf übersprungene Levels
- **Ausgabe**: Console-Warnung für Editoren
- **Beispiel**: Warnung bei H1 → H3 (H2 übersprungen)
- **Deaktivieren wenn**: Sie ein eigenes Heading-Validierungs-Tool verwenden

---

### 7. **Skip Links** ✅
- **WCAG**: 2.4.1 - Level A
- **Funktion**: "Skip to main content" und "Skip to navigation" Links
- **Sichtbarkeit**: Nur bei Fokus (Tab-Taste)
- **Deaktivieren wenn**: Sie bereits Skip-Links implementiert haben

---

### 8. **Elementor WCAG Enhancements** ✅
- **Features**:
  - Native `<header>` Wrapper für Elementor Header Templates
  - Native `<footer>` Wrapper für Elementor Footer Templates
  - Native `<article>` Wrapper für Single Posts
  - ARIA-Attribute für Widgets
  - Custom WCAG Controls in Elementor (Language Code, ARIA Label)
- **Deaktivieren wenn**: Sie Elementor nicht verwenden

---

### 9. **Reduced Motion Support** ✅
- **WCAG**: 2.3.3 - Level AAA
- **Funktion**: Respektiert `prefers-reduced-motion` Einstellung
- **Effekt**: Deaktiviert Elementor-Animationen automatisch
- **Deaktivieren wenn**: Sie Animationen manuell steuern

---

### 10. **Link Text Validation** ✅
- **WCAG**: 2.4.9 - Level AAA
- **Funktion**: Erkennt generische Link-Texte und fügt Kontext hinzu
- **Generische Texte**: "Click here", "Hier", "Mehr", "Read more"
- **Verbesserung**: Fügt Screen-Reader-Kontext hinzu
- **Deaktivieren wenn**: Sie Link-Texte manuell optimieren

---

### 11. **Semantic Image Figures** ✅
- **Funktion**: Wrapping von Bildern mit Captions in `<figure>` + `<figcaption>`
- **Vorteil**: Besseres SEO, semantisches HTML
- **Deaktivieren wenn**: Sie Bilder manuell in `<figure>` Tags wrappen

---

## 🔧 Programmatische Verwendung

### Feature-Status prüfen

```php
<?php
// Prüfen ob ein Feature aktiviert ist
if ( wcag_is_feature_enabled( 'enable_breadcrumbs' ) ) {
    // Feature ist aktiviert
    wcag_accessible_pro_breadcrumbs();
}
?>
```

### Verfügbare Feature-Namen

```php
'enable_breadcrumbs'              // Breadcrumb Navigation
'enable_accessibility_toolbar'    // Accessibility Toolbar
'enable_timeout_warning'          // Session Timeout Warning
'enable_autocomplete'             // Autocomplete Attributes
'enable_video_accessibility'      // Video Accessibility
'enable_heading_validation'       // Heading Hierarchy Validation
'enable_skip_links'               // Skip Links
'enable_elementor_enhancements'   // Elementor WCAG Enhancements
'enable_reduced_motion'           // Reduced Motion Support
'enable_link_validation'          // Link Text Validation
'enable_image_figures'            // Semantic Image Figures
```

---

## 📊 Standard-Einstellungen

**Alle Features sind standardmäßig AKTIVIERT.**

Wenn Sie das Theme zum ersten Mal installieren, sind alle Features aktiv. Sie können sie dann nach Bedarf deaktivieren.

---

## 🎯 Empfohlene Konfigurationen

### Szenario 1: Vollständige WCAG-Konformität
**Alle Features aktiviert** ✅

Verwenden Sie diese Konfiguration für maximale Barrierefreiheit und SEO-Optimierung.

---

### Szenario 2: Sie verwenden Yoast SEO oder Rank Math
**Deaktivieren**: Breadcrumb Navigation ❌

Yoast SEO und Rank Math haben eigene Breadcrumb-Funktionen mit zusätzlichen SEO-Features.

---

### Szenario 3: Sie verwenden ein Accessibility-Plugin
**Deaktivieren**: Accessibility Toolbar ❌

Wenn Sie bereits ein Plugin wie "WP Accessibility" oder "One Click Accessibility" verwenden.

---

### Szenario 4: Minimale Installation (nur Core-Features)
**Deaktivieren**:
- ❌ Accessibility Toolbar
- ❌ Session Timeout Warning
- ❌ Heading Hierarchy Validation
- ❌ Link Text Validation

**Aktiviert lassen**:
- ✅ Breadcrumb Navigation
- ✅ Autocomplete Attributes
- ✅ Video Accessibility
- ✅ Skip Links
- ✅ Elementor Enhancements
- ✅ Reduced Motion Support
- ✅ Semantic Image Figures

---

### Szenario 5: Elementor-freie Installation
**Deaktivieren**: Elementor WCAG Enhancements ❌

Wenn Sie Elementor nicht verwenden, können Sie diese Features deaktivieren.

---

## 🚨 Wichtige Hinweise

### Core-Features (IMMER aktiv)

Diese Features sind **NICHT deaktivierbar**, da sie grundlegend für WCAG-Konformität sind:

1. **Semantic HTML5**: `<header>`, `<nav>`, `<main>`, `<article>`, `<footer>`
2. **ARIA Landmarks**: `role="banner"`, `role="navigation"`, `role="main"`
3. **Focus Management**: 3px outline mit 2px offset
4. **Color Contrast**: 7:1 ratio (AAA level)
5. **Touch Targets**: Minimum 44x44px
6. **Keyboard Navigation**: Vollständige Tastatur-Zugänglichkeit

Diese Features sind im Theme-Code fest verankert und können nicht über die Settings deaktiviert werden.

---

## 🔄 Änderungen speichern

1. WordPress Admin → Design → WCAG Settings
2. Checkboxen aktivieren/deaktivieren
3. **"Save Settings"** klicken
4. Seite neu laden, um Änderungen zu sehen

---

## 🧪 Testen nach Änderungen

Nach dem Deaktivieren von Features sollten Sie testen:

1. **WAVE Accessibility Tool**: https://wave.webaim.org/
2. **Google Lighthouse**: Chrome DevTools → Lighthouse → Accessibility
3. **Screen Reader**: NVDA (Windows) oder VoiceOver (Mac)
4. **Keyboard Navigation**: Tab-Taste durch die Seite navigieren

---

## 📞 Support

Bei Fragen zu den Einstellungen:

1. Lesen Sie die Dokumentation in `Design/COMPLETE-WCAG-FEATURES.md`
2. Prüfen Sie die WCAG-Checkliste in `Design/WCAG-CHECKLIST.md`
3. Konsultieren Sie die W3C WCAG 2.1 Guidelines: https://www.w3.org/WAI/WCAG21/quickref/

---

## ✅ Zusammenfassung

- ✅ **11 deaktivierbare Features**
- ✅ **6 Core-Features (immer aktiv)**
- ✅ **Einfache Checkbox-Steuerung**
- ✅ **Keine Code-Änderungen nötig**
- ✅ **Sofortige Wirkung nach Speichern**

**Ihr Theme bleibt WCAG-konform, auch wenn Sie einzelne Features deaktivieren!**

Die Core-Features garantieren mindestens **WCAG 2.1 Level AA Konformität** (50/78 Success Criteria).

Mit allen Features aktiviert erreichen Sie **WCAG 2.1 Level AAA Konformität** (78/78 Success Criteria).

