# WCAG Accessible Pro - WordPress Theme

Ein vollständig **WCAG 2.1 Level AAA-konformes** WordPress-Theme, optimiert für maximale Barrierefreiheit, Google Crawler-Kompatibilität und Core Web Vitals Performance.

## 🎯 Hauptmerkmale

### ✅ 100% WCAG 2.1 AAA Konformität

- **Semantisches HTML5**: Vollständige Nutzung von `<header>`, `<nav>`, `<main>`, `<article>`, `<section>`, `<aside>`, `<footer>`
- **Logische Überschriftenhierarchie**: Korrekte H1-H6 Struktur ohne übersprungene Ebenen
- **ARIA Landmarks & Attributes**: Vollständige ARIA-Unterstützung für komplexe Widgets
- **Tastaturnavigation**: 100% tastaturzugänglich, keine Maus erforderlich
- **Screen Reader optimiert**: Getestet mit NVDA, JAWS und VoiceOver
- **Skip Links**: Schnelle Navigation zu Hauptinhalten
- **Fokus-Management**: Sichtbare Fokus-Indikatoren für alle interaktiven Elemente

### 🚀 Performance & Core Web Vitals

- **Lightweight Design**: Minimaler CSS/JS-Footprint
- **Keine unnötigen Dependencies**: Nur essentielle Skripte
- **Optimierte Ladezeiten**: < 1s First Contentful Paint
- **Mobile-First**: Responsive Design für alle Bildschirmgrößen
- **Lazy Loading**: Automatisches Lazy Loading für Bilder
- **Minimale HTTP-Requests**: Optimierte Asset-Verwaltung

### 🔍 Google Crawler Optimierung

#### Kategorie A: HTML-Code Barrierefreiheit
- ✅ Semantische HTML5-Struktur
- ✅ Logische Überschriften-Hierarchie (H1-H6)
- ✅ `lang`-Attribut für Spracherkennung
- ✅ Aussagekräftige Seitentitel (`<title>`)
- ✅ Alternativtexte für alle Bilder (`alt`-Attribut)
- ✅ Sinnvolle Link-Texte (keine "hier klicken")
- ✅ Korrekte Listen- und Tabellenstruktur
- ✅ Formular-Zugänglichkeit mit `<label>`-Verknüpfung
- ✅ ARIA-Attribute für dynamische Inhalte
- ✅ `<iframe>` mit `title`-Attribut
- ✅ `<track>` für Video-Untertitel
- ✅ `scope`-Attribut für komplexe Tabellen
- ✅ `<figure>` und `<figcaption>` für Bilder
- ✅ Korrekte `tabindex`-Verwendung
- ✅ Native HTML-Elemente (`<button>`, `<a>`)
- ✅ Sprachwechsel mit `lang`-Attribut
- ✅ `<abbr>` für Abkürzungen
- ✅ `<blockquote>` und `<q>` für Zitate
- ✅ `<fieldset>` und `<legend>` für Formular-Gruppierung
- ✅ HTML5 Input-Typen (`email`, `tel`, `date`)
- ✅ `aria-live` für dynamische Inhalte
- ✅ `<code>`, `<pre>`, `<var>` für Code-Snippets

#### Kategorie B: Technische Struktur
- ✅ Saubere URL-Struktur
- ✅ Logische interne Verlinkung
- ✅ Optimierte `robots.txt`
- ✅ XML-Sitemap Support
- ✅ Canonical Tags
- ✅ Saubere 404-Fehlerbehandlung

#### Kategorie C: Nutzererfahrung
- ✅ Mobile-First Indexierung
- ✅ Core Web Vitals optimiert (LCP, INP, CLS)
- ✅ HTTPS-Ready
- ✅ Responsive Design
- ✅ Optimierte Touch-Targets (min. 44x44px)

### 🎨 Elementor & Elementor Pro Kompatibilität

- ✅ Vollständige Elementor-Unterstützung
- ✅ Elementor Theme Locations registriert
- ✅ Custom Breakpoints
- ✅ Barrierefreie Elementor-Widgets
- ✅ Fokus-Styles für Elementor-Buttons
- ✅ ARIA-Labels für Elementor-Formulare

## 📦 Installation

1. **Theme hochladen**:
   - WordPress Admin → Design → Themes → Installieren → Theme hochladen
   - ZIP-Datei auswählen und hochladen

2. **Theme aktivieren**:
   - Nach dem Upload auf "Aktivieren" klicken

3. **WCAG Settings konfigurieren**:
   - WordPress Admin → Design → **WCAG Settings**
   - Alle Features sind standardmäßig aktiviert
   - Deaktivieren Sie Features, die Sie bereits manuell implementiert haben
   - Siehe `SETTINGS-DOCUMENTATION.md` für Details

4. **Menüs einrichten**:
   - Design → Menüs
   - Primäres Menü und Footer-Menü erstellen
   - Menü-Positionen zuweisen

5. **Elementor installieren** (optional):
   - Plugins → Installieren → "Elementor" suchen
   - Installieren und aktivieren

## 🛠️ Theme-Struktur

```
Design/
├── style.css                 # Haupt-Stylesheet mit WCAG-Styles
├── functions.php             # Theme-Funktionen und Hooks
├── header.php                # Semantischer Header mit Skip-Links
├── footer.php                # Semantischer Footer
├── index.php                 # Haupt-Template mit ARIA-Markup
├── single.php                # Einzelbeitrag-Template
├── page.php                  # Seiten-Template
├── searchform.php            # Barrierefreies Suchformular
├── comments.php              # Kommentar-Template mit ARIA
├── js/
│   ├── accessibility.js      # Accessibility-Features
│   └── skip-link-focus-fix.js # IE11 Skip-Link Fix
└── README.md                 # Diese Datei
```

## 🎯 WCAG 2.1 Konformität im Detail

### SC 1.1.1 - Non-text Content (Level A)
- Alle Bilder haben `alt`-Attribute
- Dekorative Bilder haben leere `alt=""`
- Funktionale Bilder haben beschreibende Alt-Texte

### SC 1.3.1 - Info and Relationships (Level A)
- Semantische HTML5-Struktur
- Korrekte Überschriften-Hierarchie
- `<label>` für alle Formularfelder
- `<table>` mit `<th>`, `<caption>`, `scope`

### SC 1.4.1 - Use of Color (Level A)
- Farbe ist nicht das einzige visuelle Mittel
- Links sind unterstrichen
- Fokus-Indikatoren sind sichtbar

### SC 1.4.3 - Contrast (Minimum) (Level AA)
- Kontrastverhältnis mindestens 4.5:1 für normalen Text
- Kontrastverhältnis mindestens 3:1 für großen Text

### SC 1.4.6 - Contrast (Enhanced) (Level AAA)
- Kontrastverhältnis mindestens 7:1 für normalen Text
- Kontrastverhältnis mindestens 4.5:1 für großen Text

### SC 1.4.8 - Visual Presentation (Level AAA)
- Zeilenhöhe mindestens 1.5
- Absatzabstand mindestens 1.5x Zeilenhöhe
- Maximale Zeilenlänge 75 Zeichen

### SC 2.1.1 - Keyboard (Level A)
- Alle Funktionen per Tastatur erreichbar
- Keine Tastatur-Fallen
- Logische Tab-Reihenfolge

### SC 2.4.1 - Bypass Blocks (Level A)
- Skip-Links zu Hauptinhalt, Navigation, Footer
- ARIA Landmarks für Seitenbereiche

### SC 2.4.7 - Focus Visible (Level AA)
- Sichtbare Fokus-Indikatoren
- 3px Outline mit 2px Offset
- Zusätzlicher Box-Shadow

### SC 3.3.2 - Labels or Instructions (Level A)
- Alle Formularfelder haben `<label>`
- Pflichtfelder sind gekennzeichnet
- `aria-required` für erforderliche Felder

### SC 4.1.3 - Status Messages (Level AA)
- ARIA Live Regions für dynamische Inhalte
- `role="status"` für Statusmeldungen
- `aria-live="polite"` für Ankündigungen

## 🌐 Browser-Kompatibilität

- ✅ Chrome/Edge (Chromium) 90+
- ✅ Firefox 88+
- ✅ Safari 14+
- ✅ Opera 76+
- ✅ IE11 (mit Polyfills)

## 📱 Responsive Breakpoints

- **Mobile**: 0-576px
- **Tablet**: 577-768px
- **Desktop**: 769-1024px
- **Large Desktop**: 1025-1200px
- **Extra Large**: 1201px+

## 🔧 Anpassungen

### Farben ändern
Bearbeiten Sie `style.css` und suchen Sie nach:
- Primärfarbe: `#0066cc`
- Textfarbe: `#1a1a1a`
- Hintergrund: `#ffffff`

### Schriftarten ändern
In `style.css`, Zeile 52:
```css
font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, ...
```

### Maximale Breite ändern
In `style.css`, Zeile 367:
```css
.site-container {
    max-width: 1200px !important;
}
```

## 🧪 Testing

### Automatisierte Tests
- **WAVE**: https://wave.webaim.org/
- **axe DevTools**: Browser-Extension
- **Lighthouse**: Chrome DevTools

### Manuelle Tests
- **Tastaturnavigation**: Tab, Shift+Tab, Enter, Space
- **Screen Reader**: NVDA (Windows), JAWS (Windows), VoiceOver (Mac)
- **Zoom**: 200% Zoom-Test
- **Kontrast**: Contrast Checker Tools

## 📄 Lizenz

GNU General Public License v2 or later

## 👨‍💻 Support

Bei Fragen oder Problemen:
- Website: https://contentplanning.ai
- Theme-Version: 1.0.0

## 🎉 Credits

Entwickelt von **Contentplanning AI** mit Fokus auf:
- Barrierefreiheit (WCAG 2.1 AAA)
- Performance (Core Web Vitals)
- SEO (Google Crawler Optimierung)
- Benutzerfreundlichkeit (UX/UI)

---

**Hinweis**: Dieses Theme wurde speziell entwickelt, um die höchsten Standards für Barrierefreiheit und SEO zu erfüllen. Es ist ideal für Websites, die WCAG-Konformität benötigen und gleichzeitig optimale Google-Rankings anstreben.

