# Feature Toggle System - Dokumentation

## 🎛️ Übersicht

Das WCAG Accessible Pro Theme verfügt über ein **vollständiges Feature-Toggle-System**, mit dem Sie jedes optionale WCAG-Feature einzeln aktivieren oder deaktivieren können.

---

## ✅ Warum Feature-Toggles?

### Problem
Sie haben möglicherweise bereits einige WCAG-Features manuell implementiert oder verwenden Plugins, die bestimmte Funktionen bereitstellen (z.B. Yoast SEO für Breadcrumbs).

### Lösung
Mit dem Feature-Toggle-System können Sie:
- ✅ Doppelte Implementierungen vermeiden
- ✅ Konflikte mit anderen Plugins verhindern
- ✅ Performance optimieren (nur benötigte Features laden)
- ✅ Flexibel zwischen Theme-Features und eigenen Lösungen wechseln

---

## 📍 Zugriff auf die Einstellungen

**WordPress Admin → Design → WCAG Settings**

oder

**WordPress Admin → Appearance → WCAG Settings**

---

## 🔧 Verfügbare Feature-Toggles

### 1. Breadcrumb Navigation
- **Toggle**: `enable_breadcrumbs`
- **WCAG**: 2.4.8 - Level AAA
- **Deaktivieren wenn**: Yoast SEO, Rank Math, oder eigene Breadcrumbs

### 2. Accessibility Toolbar
- **Toggle**: `enable_accessibility_toolbar`
- **Deaktivieren wenn**: WP Accessibility Plugin, One Click Accessibility

### 3. Session Timeout Warning
- **Toggle**: `enable_timeout_warning`
- **WCAG**: 2.2.6 - Level AAA
- **Deaktivieren wenn**: Eigenes Session-Management

### 4. Autocomplete Attributes
- **Toggle**: `enable_autocomplete`
- **WCAG**: 1.3.6 - Level AAA
- **Deaktivieren wenn**: Manuelle Autocomplete-Implementierung

### 5. Video Accessibility Enhancements
- **Toggle**: `enable_video_accessibility`
- **WCAG**: 1.2.x
- **Deaktivieren wenn**: Manuelle Video-Caption-Implementierung

### 6. Heading Hierarchy Validation
- **Toggle**: `enable_heading_validation`
- **WCAG**: 2.4.10 - Level AAA
- **Deaktivieren wenn**: Eigenes Heading-Validierungs-Tool

### 7. Skip Links
- **Toggle**: `enable_skip_links`
- **WCAG**: 2.4.1 - Level A
- **Deaktivieren wenn**: Bereits Skip-Links implementiert

### 8. Elementor WCAG Enhancements
- **Toggle**: `enable_elementor_enhancements`
- **Deaktivieren wenn**: Elementor nicht verwendet

### 9. Reduced Motion Support
- **Toggle**: `enable_reduced_motion`
- **WCAG**: 2.3.3 - Level AAA
- **Deaktivieren wenn**: Manuelle Animation-Steuerung

### 10. Link Text Validation
- **Toggle**: `enable_link_validation`
- **WCAG**: 2.4.9 - Level AAA
- **Deaktivieren wenn**: Manuelle Link-Text-Optimierung

### 11. Semantic Image Figures
- **Toggle**: `enable_image_figures`
- **Deaktivieren wenn**: Manuelle `<figure>` Implementierung

---

## 🔒 Core-Features (NICHT deaktivierbar)

Diese Features sind **immer aktiv** und können nicht deaktiviert werden:

1. **Semantic HTML5**: `<header>`, `<nav>`, `<main>`, `<article>`, `<footer>`
2. **ARIA Landmarks**: `role="banner"`, `role="navigation"`, `role="main"`
3. **Focus Management**: 3px outline mit 2px offset
4. **Color Contrast**: 7:1 ratio (AAA level)
5. **Touch Targets**: Minimum 44x44px
6. **Keyboard Navigation**: Vollständige Tastatur-Zugänglichkeit

**Warum?** Diese Features sind grundlegend für WCAG-Konformität und können nicht ohne Verlust der Barrierefreiheit entfernt werden.

---

## 💻 Programmatische Verwendung

### Feature-Status prüfen

```php
<?php
// Prüfen ob ein Feature aktiviert ist
if ( wcag_is_feature_enabled( 'enable_breadcrumbs' ) ) {
    // Feature ist aktiviert
    wcag_accessible_pro_breadcrumbs();
}
?>
```

### In eigenen Plugins/Themes verwenden

```php
<?php
// Beispiel: Eigene Breadcrumbs nur anzeigen, wenn Theme-Breadcrumbs deaktiviert sind
if ( ! wcag_is_feature_enabled( 'enable_breadcrumbs' ) ) {
    // Theme-Breadcrumbs sind deaktiviert
    // Zeige eigene Breadcrumbs
    my_custom_breadcrumbs();
}
?>
```

---

## 🎯 Empfohlene Konfigurationen

### Szenario 1: Vollständige WCAG-Konformität (Standard)
```
✅ Alle Features aktiviert
```
**Verwendung**: Neue Website ohne bestehende Accessibility-Implementierung

---

### Szenario 2: Mit Yoast SEO / Rank Math
```
❌ Breadcrumb Navigation (deaktiviert)
✅ Alle anderen Features (aktiviert)
```
**Grund**: Yoast/Rank Math haben eigene Breadcrumb-Funktionen

---

### Szenario 3: Mit Accessibility-Plugin
```
❌ Accessibility Toolbar (deaktiviert)
✅ Alle anderen Features (aktiviert)
```
**Grund**: Vermeidung doppelter Toolbars

---

### Szenario 4: Ohne Elementor
```
❌ Elementor WCAG Enhancements (deaktiviert)
✅ Alle anderen Features (aktiviert)
```
**Grund**: Elementor-spezifische Features werden nicht benötigt

---

### Szenario 5: Minimale Installation
```
❌ Accessibility Toolbar
❌ Session Timeout Warning
❌ Heading Hierarchy Validation
❌ Link Text Validation
✅ Breadcrumb Navigation
✅ Autocomplete Attributes
✅ Video Accessibility
✅ Skip Links
✅ Elementor Enhancements
✅ Reduced Motion Support
✅ Semantic Image Figures
```
**Verwendung**: Performance-optimierte Installation mit essentiellen Features

---

## 🔄 Technische Implementierung

### Wie funktioniert das System?

1. **Zentrale Funktion**: `wcag_is_feature_enabled( $feature_name )`
2. **Speicherung**: WordPress Options API (`wcag_accessibility_options`)
3. **Standard**: Alle Features sind aktiviert (true)
4. **Prüfung**: Jede Feature-Funktion prüft zuerst den Toggle-Status

### Code-Beispiel

```php
function wcag_accessible_pro_breadcrumbs( $args = array() ) {
    // Prüfe ob Feature aktiviert ist
    if ( ! wcag_is_feature_enabled( 'enable_breadcrumbs' ) ) {
        return; // Feature ist deaktiviert, nichts tun
    }
    
    // Feature ist aktiviert, führe Funktion aus
    // ... Breadcrumb-Code ...
}
```

---

## 📊 WCAG-Konformität nach Konfiguration

### Alle Features aktiviert
- **Level A**: 25/25 ✅
- **Level AA**: 20/20 ✅
- **Level AAA**: 33/33 ✅
- **Gesamt**: 78/78 (100%) ✅

### Nur Core-Features (alle Toggles deaktiviert)
- **Level A**: 20/25 ✅
- **Level AA**: 15/20 ✅
- **Level AAA**: 15/33 ⚠️
- **Gesamt**: 50/78 (64%) ⚠️

**Empfehlung**: Mindestens Level AA (50/78) für produktive Websites

---

## 🧪 Testen nach Änderungen

Nach dem Aktivieren/Deaktivieren von Features:

1. **Cache leeren**: Browser-Cache und WordPress-Cache
2. **Seite neu laden**: Hard Reload (Ctrl+Shift+R / Cmd+Shift+R)
3. **WAVE Tool**: https://wave.webaim.org/
4. **Lighthouse**: Chrome DevTools → Lighthouse → Accessibility
5. **Screen Reader**: NVDA (Windows) oder VoiceOver (Mac)

---

## 🚨 Wichtige Hinweise

### Performance
- Deaktivierte Features werden **nicht geladen** (kein CSS/JS)
- Verbessert Performance bei selektiver Deaktivierung

### Kompatibilität
- Feature-Toggles sind **abwärtskompatibel**
- Bestehende Implementierungen bleiben funktionsfähig

### Updates
- Feature-Einstellungen bleiben bei Theme-Updates erhalten
- Neue Features sind standardmäßig aktiviert

---

## 📞 Support & Dokumentation

### Weitere Dokumentation
- `SETTINGS-DOCUMENTATION.md` - Detaillierte Settings-Dokumentation
- `COMPLETE-WCAG-FEATURES.md` - Vollständige Feature-Liste
- `WCAG-CHECKLIST.md` - WCAG 2.1 Checkliste
- `README.md` - Theme-Dokumentation

### Hilfe bei Problemen
1. Prüfen Sie die Dokumentation
2. Testen Sie mit allen Features aktiviert
3. Deaktivieren Sie Features einzeln, um Konflikte zu identifizieren
4. Konsultieren Sie die W3C WCAG 2.1 Guidelines

---

## ✅ Zusammenfassung

- ✅ **11 deaktivierbare Features**
- ✅ **6 Core-Features (immer aktiv)**
- ✅ **Einfache Checkbox-Steuerung**
- ✅ **Keine Code-Änderungen nötig**
- ✅ **Performance-Optimierung möglich**
- ✅ **Flexibel & erweiterbar**

**Das Feature-Toggle-System gibt Ihnen volle Kontrolle über die WCAG-Features Ihres Themes!**

