<?php
/**
 * The template for displaying 404 pages (Not Found)
 *
 * @package WCAG_Accessible_Pro
 * @since 1.0.0
 */

get_header();
?>

<div class="content-area">
    
    <section class="error-404 not-found">
        <header class="page-header">
            <h1 class="page-title"><?php esc_html_e( '404 - Page Not Found', 'wcag-accessible-pro' ); ?></h1>
        </header><!-- .page-header -->
        
        <div class="page-content">
            <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'wcag-accessible-pro' ); ?></p>
            
            <?php get_search_form(); ?>
            
            <h2><?php esc_html_e( 'Try these helpful links instead:', 'wcag-accessible-pro' ); ?></h2>
            
            <nav aria-label="<?php esc_attr_e( 'Helpful links', 'wcag-accessible-pro' ); ?>">
                <ul>
                    <li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home Page', 'wcag-accessible-pro' ); ?></a></li>
                    <?php
                    wp_list_pages(
                        array(
                            'title_li' => '',
                            'depth'    => 1,
                            'number'   => 5,
                        )
                    );
                    ?>
                </ul>
            </nav>
        </div><!-- .page-content -->
    </section><!-- .error-404 -->
    
</div><!-- .content-area -->

<?php
get_footer();

