/**
 * Breadcrumbs for Elementor - Frontend Scripts
 *
 * @package Breadcrumbs_For_Elementor
 * @since 1.0.0
 */

(function($) {
	'use strict';

	/**
	 * Breadcrumbs Widget Handler
	 */
	var BreadcrumbsHandler = function($scope, $) {
		var $breadcrumbs = $scope.find('.bfe-breadcrumbs');

		if ($breadcrumbs.length === 0) {
			return;
		}

		// Add accessibility attributes
		$breadcrumbs.attr('aria-label', 'Breadcrumb');

		// Smooth scroll for anchor links
		$breadcrumbs.find('a[href^="#"]').on('click', function(e) {
			var target = $(this).attr('href');
			if (target && target !== '#') {
				var $target = $(target);
				if ($target.length) {
					e.preventDefault();
					$('html, body').animate({
						scrollTop: $target.offset().top - 100
					}, 500);
				}
			}
		});
	};

	// Initialize on Elementor frontend
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction(
			'frontend/element_ready/breadcrumbs-for-elementor.default',
			BreadcrumbsHandler
		);
	});

})(jQuery);

